// Create - Créer un nouveau burger
// Read - lire la liste en cours
// Update - modifier le nom ou le prix des burgers existants
// Delete - supprimer un burger de la liste

//  ce fichier principal ne contient que la logique dite métier
//  et appelle les outils dont il a besoin dans les fichiers annexes

import { listBurgers } from "./datas/burgersList.js";
import { createBurger } from "./utilities/create.js";
import { deleteBurger } from "./utilities/delete.js";
import { showBurgers } from "./utilities/read.js";
import { updateBurgerName, updateBurgerPrice } from "./utilities/update.js";

let action = null;


while (action !== 5) {
  action = Number(
    prompt(
      "Que souhaites tu faire ? \n" +
        "1 - ajouter un nouveau burger \n" +
        "2 - modifier le nom d'un burger \n" +
        "3 - modifier le prix d'un burger \n" +
        "4 - supprimer un burger \n" +
        "5 - afficher la carte des burgers et quitter l'application \n"
    )
  );


  //  quand un switch / case vaut mieux qu'une cascade de if else....

  switch (action) {
    case 1:
      createBurger(listBurgers)
      break;    //=> permet de sortir du switch, si dans une fonction, on sort du switch mais pas de la fonction contrairement à return
    case 2:
      updateBurgerName(listBurgers)
      break;
    case 3:
      updateBurgerPrice(listBurgers)
      break;
    case 4:
      deleteBurger(listBurgers)
      break;
    case 5:
      showBurgers(listBurgers)
      break;

    default:
      console.log("Action inconnue");
      break;
  }
  showBurgers(listBurgers) // A retirer
}
console.log("Merci et à bientôt");
