import { isNameExisting, isPriceValid } from "./helpers.js";


export function createBurger(list) {
  const name = prompt("Quel est le nom du burger ?").trim();
  if (isNameExisting(list, name)) {
    alert(`❌ Le burger ${name} existe déjà !`);
    return;
  }

  const price = Number(prompt("Quel est le prix du burger ?"));
  if(! isPriceValid(price)){
    alert("❌ Le prix doit être un nombre entre 1 et 25€ !")
    return
  }

  list.push({ name, price });
  alert(`le burger ${name} à ${price} a bien été ajouté.`);
}
