import {
  getBurgerIndexByName,
  isNameExisting,
  isPriceValid,
} from "./helpers.js";

export function updateBurgerName(list) {
  const name = prompt("Quel est le burger à modifier ?").trim();

  const index = getBurgerIndexByName(list, name);

  if (index === -1) {
    alert(`❌ Le burger ${name} n'existe pas !`);
    return;
  }

  const newName = prompt("Quel sera le nouveau nom pour ce burger ? ").trim();
  if (isNameExisting(list, newName)) {
    alert(`❌ Le burger ${newName} existe déjà !`);
    return;
  }

  list[index].name = newName;

  alert(`Le burger ${name} a bien été modifié en ${newName} !`);
}

export function updateBurgerPrice(list) {
  const name = prompt("Quel est le burger à modifier ?").trim();

  const index = getBurgerIndexByName(list, name);

  if (index === -1) {
    alert(`❌ Le burger ${name} n'existe pas !`);
    return;
  }

  const newPrice = Number(
    prompt(
      "Quel est le nouveau prix du burger ? (ancien prix : " +
        list[index].price +
        "€)"
    )
  );
  if (!isPriceValid(newPrice)) {
    alert("❌ Le prix doit être un nombre entre 1 et 25€ !");
    return;
  }
  list[index].price = newPrice;

  alert(`Le prix du burger ${name} a bien été modifié en ${newPrice}€ !`);
}
